SET search_path = social;
/***************
**  OBSERVACAO **
****************/
--LINHA ABAIXO EXECUTAR SOMENTE EM CASO DE ATUALIZACAO MANUAL (REMOVER OS -- DA FRENTE)
-- UPDATE social.schema_version SET version='144', script='V144__3.177.176.sql',installed_on=NOW();

/***************
* MODULO SAUDE *
****************/
--Atualiza Versao
UPDATE config SET conf_valor_data=CURRENT_DATE WHERE conf_chave='DATA_INSTALACAO_SAUDE';
UPDATE config SET conf_valor_string='3.177.176' WHERE conf_chave='VERSAO_SAUDE';
-- UPDATE config SET conf_valor_string='Compatível com a versão PEC: 2.2.17 do e-SUS' WHERE conf_chave = 'VERSAO_ESUS';

/* 263120 - Obrigatoriedade em filtro não está sendo respeitada */
UPDATE acesso SET ace_descricao = 'Atendimento Realizado aos Munícipes por Faixa Etária' WHERE ace_descricao LIKE('%Atendimento Realizado aos Munícipes%');
/* 263120 - Fim */

/* 237205 - Relatório de cidadãos cadastrados */
INSERT INTO acesso(ace_descricao, ace_pai, ace_modulo, ace_caminho) VALUES ('Cidadãos Cadastrados', (SELECT ace_codigo FROM acesso WHERE ace_descricao = 'Relatórios' LIMIT 1), 13, 'zf/relatorio/cidadaos-cadastrados/form-cidadaos-cadastrados');
/* 237205 - Fim */


/* 262451 - Inclusão de Campo Estratégia */
CREATE TABLE estrategia (
  est_codigo BIGSERIAL NOT NULL,
  est_descricao CHARACTER VARYING,
  est_sigla CHARACTER VARYING,
  CONSTRAINT estrategia_pkey PRIMARY KEY (est_codigo)
);
ALTER TABLE vacina_usuario ADD COLUMN est_codigo INTEGER;
ALTER TABLE vacina_usuario ADD CONSTRAINT fk_est_codigo FOREIGN KEY (est_codigo) REFERENCES estrategia (est_codigo);

INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (1, 'Bloqueio', 'B');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (2, 'Campanha indiscriminada', 'CI');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (3, 'Campanha seletiva', 'CS');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (4, 'Especial', 'E');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (5, 'Intensificação', 'I');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (6, 'Monitoramento Rápido de Cobertura Vacinal', 'MRCV');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (7, 'Rotina', 'R');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (8, 'Serviço Privado', 'SP');
INSERT INTO estrategia (est_codigo, est_descricao, est_sigla) VALUES (9, 'Soroterapia', 'S');
/* 262451 - Fim */

/* 259267 - Feriado no agendamento conveniado */
ALTER TABLE convenio ADD COLUMN conv_feriados BOOLEAN NOT NULL DEFAULT 'F';
/* 259267 - Fim */


/* 273171 - Erro ao atualizar cadastro individual */

CREATE OR REPLACE FUNCTION esus_cadastro_individual()
  RETURNS trigger AS
$BODY$
DECLARE
  usu_codigo_conf bigint;
  eci_sexo character(20);
  eci_raca character(20);
  eci_nacionalidade character(20);
  eci_exportado integer;
  eci_origem_prontuario boolean;
  linha RECORD;
BEGIN
IF (TG_OP='INSERT') THEN
  SELECT usu_origem_prontuario INTO eci_origem_prontuario FROM usuario WHERE usu_codigo = NEW.usu_codigo;
 ELSE
  SELECT usu_origem_prontuario INTO eci_origem_prontuario FROM usuario WHERE usu_codigo = OLD.usu_codigo;
END IF;
  IF (TG_OP='DELETE') THEN
    DELETE FROM esus_cadastro_individual WHERE usu_codigo = OLD.usu_codigo;
    RAISE NOTICE 'DELETE''.';
  ELSE
    IF (eci_origem_prontuario = FALSE) THEN
      FOR linha IN
      SELECT
        usu.usu_codigo,
        uni.uni_cnes AS eci_cnes,
        usr.cnes_cod_cns AS eci_usr_cns,
        uni.uni_codigo_ibge AS eci_usr_codigo_ibge,
        usu.usu_data_cad AS eci_dtatendimento,
        cid.cid_codigo_ibge AS eci_usu_codigo_ibge,
        usu.usu_datanasc AS eci_usu_dtnascimento,
        usu.cd_nacionalidade AS eci_usu_nacionalidade,
        usu.usu_nome AS eci_usu_nome,
        usu.usu_mae AS eci_usu_mae,
        usu.rac_codigo AS eci_usu_raca,
        usu.usu_sexo AS eci_usu_sexo,
        usu.usu_freq_escolar AS eci_usu_escola,
        usu.usu_deficiencia AS eci_usu_deficiencia,
        usu.usu_sit_rua AS eci_usu_sit_rua,
        usu.usu_cartao_sus AS eci_usu_cns,
        usu.usu_microarea AS eci_usu_microarea,
        usu.usu_microarea_fa AS eci_usu_microarea_fa,
        esp.cod_cbo AS eci_usr_cbo
      FROM
        usuario AS usu
        INNER JOIN
        usuarios AS usr ON usu.usr_codigo=usr.usr_codigo
        INNER JOIN
        unidade AS uni ON usu.uni_codigo=uni.uni_codigo
        INNER JOIN
        especialidade AS esp ON usu.usr_esp_codigo=esp.esp_codigo
        LEFT JOIN
        cidade AS cid ON usu.cid_codigo_nasc=cid.cid_codigo
      WHERE
        usu.usu_codigo = NEW.usu_codigo LOOP
        -- Validação de sexo
        IF (linha.eci_usu_sexo='M') THEN eci_sexo = '0 L'; ELSE eci_sexo = '1 L'; END IF;
        -- Validação nacionalidade
        IF (linha.eci_usu_nacionalidade='B') THEN eci_nacionalidade = '1 L'; END IF;
        IF (linha.eci_usu_nacionalidade='E') THEN eci_nacionalidade = '3 L'; END IF;
        IF (linha.eci_usu_nacionalidade='N') THEN eci_nacionalidade = '2 L'; END IF;
        -- Validação Raça
        IF (linha.eci_usu_raca='1') THEN eci_raca = '1 L'; END IF;
        IF (linha.eci_usu_raca='2') THEN eci_raca = '2 L'; END IF;
        IF (linha.eci_usu_raca='3') THEN eci_raca = '3 L'; END IF;
        IF (linha.eci_usu_raca='4') THEN eci_raca = '4 L'; END IF;
        IF (linha.eci_usu_raca='5') THEN eci_raca = '5 L'; END IF;
        IF (linha.eci_usu_raca='6') THEN eci_raca = '1 L'; END IF;
        SELECT count(*) into eci_exportado from esus_cadastro_individual where usu_codigo = NEW.usu_codigo;
        IF (TG_OP='UPDATE' AND eci_exportado > 0) THEN

          INSERT INTO esus_cadastro_individual
          (usu_codigo,
           eci_usr_cnes,
           eci_usr_profissional_cns,
           eci_usr_codigo_ibge,
           eci_usr_dtatendimento,
           eci_usu_codigo_ibge,
           eci_usu_dtnascimento,
           eci_usu_nacionalidade,
           eci_usu_nome,
           eci_usu_mae,
           eci_usu_raca,
           eci_usu_sexo,
           eci_usu_escola,
           eci_usu_deficiencia,
           eci_usu_cns,
           eci_tipo_dado_serializado,
           eci_usu_sit_rua,
	   eci_usu_microarea,
	   eci_usu_microarea_fa,
	   eci_usr_cbo,
           uuid_ficha_ori
           )
          VALUES
            (linha.usu_codigo,
              linha.eci_cnes,
              linha.eci_usr_cns,
              linha.eci_usr_codigo_ibge,
              NOW(),
              linha.eci_usu_codigo_ibge,
              linha.eci_usu_dtnascimento,
              eci_nacionalidade,
              linha.eci_usu_nome,
              linha.eci_usu_mae,
              eci_raca,
             eci_sexo,
             linha.eci_usu_escola,
             linha.eci_usu_deficiencia,
             linha.eci_usu_cns,
             '2 L',
             linha.eci_usu_sit_rua,
	     linha.eci_usu_microarea,
	     linha.eci_usu_microarea_fa,
	     linha.eci_usr_cbo,
             (select uuid_ficha
              from esus_cadastro_individual
              where usu_codigo = linha.usu_codigo
              order by eci_codigo asc
              limit 1));

          RAISE NOTICE 'UPDATE''.';

        ELSE
          -- INSERÇÃO
          INSERT INTO esus_cadastro_individual
          (usu_codigo,
           eci_usr_cnes,
           eci_usr_profissional_cns,
           eci_usr_codigo_ibge,
           eci_usr_dtatendimento,
           eci_usu_codigo_ibge,
           eci_usu_dtnascimento,
           eci_usu_nacionalidade,
           eci_usu_nome,
           eci_usu_mae,
           eci_usu_raca,
           eci_usu_sexo,
           eci_usu_escola,
           eci_usu_deficiencia,
           eci_usu_cns,
           eci_tipo_dado_serializado,
           eci_usu_sit_rua,
           eci_usu_microarea,
           eci_usu_microarea_fa,
           eci_usr_cbo)
          VALUES
            (linha.usu_codigo,
              linha.eci_cnes,
              linha.eci_usr_cns,
              linha.eci_usr_codigo_ibge,
              NOW(),
              linha.eci_usu_codigo_ibge,
              linha.eci_usu_dtnascimento,
              eci_nacionalidade,
              linha.eci_usu_nome,
              linha.eci_usu_mae,
              eci_raca,
             eci_sexo,
             linha.eci_usu_escola,
             linha.eci_usu_deficiencia,
             linha.eci_usu_cns,
             '2 L',
             linha.eci_usu_sit_rua,
             linha.eci_usu_microarea,
             linha.eci_usu_microarea_fa,
             linha.eci_usr_cbo);
        END IF;
      END LOOP;
    END IF;
    RAISE NOTICE 'INSERT''.';
  END IF;
  RETURN NULL;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;

/* 273171 - Fim */

/*273465 - CBO não consta na tabela de acesso às fichas do esus*/
SELECT setval('acessos_ficha_esus_afe_codigo_seq', (select max(afe_codigo) from acessos_ficha_esus), true);

INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('223305', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322405', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'o');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('322425', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('352210', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('515305', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('226305', 'ad');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239415', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ai');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('234410', 'ca');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'ci');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'cd');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'ac');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'p');
INSERT INTO acessos_ficha_esus (afe_cbo, afe_ficha) VALUES ('239425', 'ca');
/*273465 - Fim*/


/*222785 - Inclusão de informações Relatórios de vacinas*/
INSERT INTO permissoes(perm_descricao, perm_programa, perm_objeto) VALUES ('Relatórios Vacina', 'zf/relatorio/vacina','zf/relatorio/vacina');
/*222785 - Fim*/